<?php

/**
 * This is the model class for table "SzkoleniePracownika".
 *
 * The followings are the available columns in table 'SzkoleniePracownika':
 * @property double $id
 * @property double $idPracownika
 * @property double $idSzkolenia
 * @property string $dataSzkolenia
 */
class SzkoleniePracownika extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SzkoleniePracownika the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'SzkoleniePracownika';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idPracownika, idSzkolenia', 'required'),
			array('idPracownika, idSzkolenia', 'numerical'),
			array('dataSzkolenia', 'safe'),

			array('id, idPracownika, idSzkolenia, dataSzkolenia', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'idPracownika0'=>array(self::BELONGS_TO, 'Pracownik', 'idPracownika'),
			'idSzkolenia0'=>array(self::BELONGS_TO, 'Szkolenie', 'idSzkolenia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('SzkoleniePracownika', 'id'),
			'idPracownika'=>Yii::t('SzkoleniePracownika', 'idPracownika'),
			'idSzkolenia'=>Yii::t('SzkoleniePracownika', 'idSzkolenia'),
			'dataSzkolenia'=>Yii::t('SzkoleniePracownika', 'dataSzkolenia'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idPracownika', $this->idPracownika);
		$criteria->compare('idSzkolenia', $this->idSzkolenia);
		$criteria->compare('dataSzkolenia', $this->dataSzkolenia, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getDataSzkoleniaYmd()
	{
		return empty($this->dataSzkolenia) ? '' : date('Y/m/d', strtotime($this->dataSzkolenia));
	}
}